<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // الاسم التجاري أو الفردي
            $table->string('vat_number')->nullable(); // الرقم الضريبي
            $table->enum('customer_type', ['individual', 'business'])->default('individual'); // نوع العميل
            $table->string('national_id')->nullable(); // الهوية الوطنية للأفراد
            $table->string('cr_number')->nullable(); // السجل التجاري للشركات
            
            // العنوان الوطني السعودي (إجباري)
            $table->string('city'); // المدينة
            $table->string('district'); // الحي
            $table->string('street'); // الشارع
            $table->string('building_number'); // رقم المبنى
            $table->string('additional_number'); // الرقم الإضافي
            $table->string('postal_code'); // الرمز البريدي
            $table->string('unit_number')->nullable(); // رقم الوحدة
            
            // بيانات الاتصال
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            
            // معلومات إضافية
            $table->text('notes')->nullable(); // ملاحظات
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
