<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم الشركة
            $table->string('vat_number')->unique(); // الرقم الضريبي
            $table->string('cr_number')->nullable(); // رقم السجل التجاري
            
            // العنوان الوطني السعودي
            $table->string('city'); // المدينة
            $table->string('district'); // الحي
            $table->string('street'); // الشارع
            $table->string('building_number'); // رقم المبنى
            $table->string('additional_number'); // الرقم الإضافي
            $table->string('postal_code'); // الرمز البريدي
            $table->string('unit_number')->nullable(); // رقم الوحدة
            
            // بيانات الاتصال
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('website')->nullable();
            
            // حالة الشركة
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
