<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_vouchers', function (Blueprint $table) {
            $table->id();
            $table->string('voucher_number')->unique();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->string('supplier_name');
            $table->foreignId('supplier_id')->nullable()->constrained('customers')->onDelete('set null');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->datetime('payment_date');
            $table->decimal('amount', 15, 2);
            $table->enum('payment_method', ['cash', 'bank_transfer', 'check', 'credit_card', 'online_transfer', 'other']);
            $table->string('reference_number')->nullable();
            $table->text('notes')->nullable();
            $table->string('invoice_reference')->nullable();
            $table->string('account_code', 50)->nullable();
            $table->string('description', 500);
            $table->enum('status', ['active', 'cancelled', 'pending'])->default('active');
            $table->string('beneficiary_name')->nullable();
            $table->string('beneficiary_account')->nullable();
            $table->timestamps();

            // فهارس للبحث السريع
            $table->index(['company_id', 'payment_date']);
            $table->index(['supplier_id', 'payment_date']);
            $table->index(['status', 'payment_date']);
            $table->index('voucher_number');
            $table->index('supplier_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_vouchers');
    }
};