<?php

/**
 * تكوين ZATCA Phase 2 المحسن
 * Enhanced ZATCA Phase 2 Configuration
 */

return [

    /*
    |--------------------------------------------------------------------------
    | ZATCA Phase 2 Environment Settings
    |--------------------------------------------------------------------------
    */
    
    'phase2' => [
        'enabled' => env('ZATCA_PHASE2_ENABLED', true),
        'sandbox_mode' => env('ZATCA_SANDBOX_MODE', true),
        'testing_mode' => env('ZATCA_TESTING_MODE', false),
    ],

    /*
    |--------------------------------------------------------------------------
    | Enhanced QR Code Configuration for Phase 2
    |--------------------------------------------------------------------------
    */
    
    'qr_code' => [
        'max_length' => 1000, // الحد الأقصى للطول
        'encoding' => 'UTF-8',
        'tags' => [
            'basic' => [1, 2, 3, 4, 5], // العلامات الأساسية
            'phase2_simplified' => [6, 7, 8, 9], // علامات المرحلة الثانية للفواتير المبسطة
        ],
        'validation' => [
            'strict_mode' => true,
            'auto_truncate' => true,
            'fallback_enabled' => true,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Digital Signature Configuration
    |--------------------------------------------------------------------------
    */
    
    'digital_signature' => [
        'algorithm' => 'ecdsa-sha256',
        'canonicalization' => 'http://www.w3.org/2006/12/xml-c14n11',
        'xades_enabled' => true,
        'advanced_signature' => true,
        'fallback_basic' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Certificate Management
    |--------------------------------------------------------------------------
    */
    
    'certificate' => [
        'validation' => [
            'strict_expiry_check' => true,
            'validate_chain' => true,
            'check_revocation' => false, // للبيئة التطويرية
        ],
        'sources' => [
            'settings_db',
            'invoice_response',
            'exported_file',
            'environment_variable',
            'test_certificate' // للبيئة التجريبية
        ],
        'test_certificate_path' => base_path('exported_certificate.pem'),
    ],

    /*
    |--------------------------------------------------------------------------
    | XML Generation Settings
    |--------------------------------------------------------------------------
    */
    
    'xml' => [
        'version' => '1.0',
        'encoding' => 'UTF-8',
        'format_output' => true,
        'preserve_whitespace' => false,
        'validation' => [
            'schema_validation' => false, // تعطيل للأداء
            'element_validation' => true,
            'compliance_check' => true,
        ],
        'namespaces' => [
            'ubl' => 'urn:oasis:names:specification:ubl:schema:xsd:Invoice-2',
            'cac' => 'urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2',
            'cbc' => 'urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2',
            'ext' => 'urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2',
            'ds' => 'http://www.w3.org/2000/09/xmldsig#',
            'xades' => 'http://uri.etsi.org/01903/v1.3.2#',
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Invoice Hash Configuration
    |--------------------------------------------------------------------------
    */
    
    'invoice_hash' => [
        'algorithm' => 'sha256',
        'encoding' => 'base64',
        'validate_format' => true,
        'auto_generate' => true,
        'update_on_change' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Compliance Validation Rules
    |--------------------------------------------------------------------------
    */
    
    'compliance' => [
        'phase2_rules' => [
            'qr_code_required' => true,
            'invoice_hash_required' => true,
            'uuid_required' => true,
            'digital_signature_recommended' => true,
            'certificate_validation' => true,
        ],
        'simplified_invoice' => [
            'phase2_tags_required' => true,
            'additional_signature_elements' => true,
            'enhanced_cryptographic_support' => true,
        ],
        'standard_invoice' => [
            'full_signature_required' => true,
            'xades_support' => true,
            'certificate_chain_validation' => true,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Error Handling and Logging
    |--------------------------------------------------------------------------
    */
    
    'error_handling' => [
        'detailed_logging' => env('ZATCA_DETAILED_LOGGING', true),
        'log_level' => env('ZATCA_LOG_LEVEL', 'info'),
        'fallback_strategies' => [
            'qr_code_fallback' => true,
            'signature_fallback' => true,
            'certificate_fallback' => true,
        ],
        'retry_attempts' => 3,
        'timeout_seconds' => 30,
    ],

    /*
    |--------------------------------------------------------------------------
    | Performance Optimization
    |--------------------------------------------------------------------------
    */
    
    'performance' => [
        'cache_enabled' => true,
        'cache_ttl' => 3600, // ساعة واحدة
        'async_processing' => false,
        'batch_processing' => [
            'enabled' => true,
            'batch_size' => 50,
            'parallel_threads' => 3,
        ],
        'memory_optimization' => [
            'dom_cleanup' => true,
            'gc_collect_cycles' => true,
            'memory_limit_check' => true,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Testing and Development
    |--------------------------------------------------------------------------
    */
    
    'testing' => [
        'mock_zatca_responses' => env('ZATCA_MOCK_RESPONSES', false),
        'use_test_certificates' => env('ZATCA_USE_TEST_CERTS', true),
        'skip_signature_validation' => env('ZATCA_SKIP_SIG_VALIDATION', false),
        'generate_test_data' => env('ZATCA_GENERATE_TEST_DATA', true),
        'compliance_test_suite' => [
            'enabled' => true,
            'auto_run' => false,
            'detailed_reports' => true,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | ZATCA API Configuration
    |--------------------------------------------------------------------------
    */
    
    'api' => [
        'sandbox' => [
            'base_url' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/developer-portal',
            'timeout' => 60,
            'retry_attempts' => 3,
            'rate_limit' => [
                'requests_per_minute' => 60,
                'burst_limit' => 10,
            ]
        ],
        'production' => [
            'base_url' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/core',
            'timeout' => 30,
            'retry_attempts' => 2,
            'rate_limit' => [
                'requests_per_minute' => 120,
                'burst_limit' => 20,
            ]
        ],
        'headers' => [
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
            'Accept-Version' => 'V2',
            'Accept-Language' => 'en',
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Settings
    |--------------------------------------------------------------------------
    */
    
    'security' => [
        'ssl_verification' => env('ZATCA_SSL_VERIFY', false), // false للبيئة التطويرية
        'certificate_validation' => [
            'validate_expiry' => true,
            'validate_chain' => false, // false للبيئة التطويرية
            'validate_hostname' => false,
        ],
        'data_encryption' => [
            'encrypt_stored_certificates' => false,
            'encrypt_responses' => false,
            'secure_key_storage' => true,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Monitoring and Analytics
    |--------------------------------------------------------------------------
    */
    
    'monitoring' => [
        'performance_tracking' => true,
        'error_tracking' => true,
        'success_rate_monitoring' => true,
        'compliance_metrics' => [
            'track_phase2_adoption' => true,
            'measure_qr_code_success' => true,
            'signature_validation_rate' => true,
        ],
        'alerts' => [
            'certificate_expiry_warning' => 30, // أيام
            'compliance_failure_threshold' => 5, // %
            'api_error_threshold' => 10, // %
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Integration Settings
    |--------------------------------------------------------------------------
    */
    
    'integration' => [
        'fatoora_tool' => [
            'enabled' => true,
            'path_detection' => true,
            'fallback_internal' => true,
        ],
        'external_validation' => [
            'enabled' => false,
            'validation_service_url' => null,
            'timeout' => 15,
        ],
        'webhook_notifications' => [
            'enabled' => false,
            'success_webhook' => null,
            'failure_webhook' => null,
        ]
    ]

];