<?php

return [
    /*
    |--------------------------------------------------------------------------
    | ZATCA Default Configuration
    |--------------------------------------------------------------------------
    |
    | هذا الملف يحتوي على الإعدادات الافتراضية لنظام ZATCA
    | للمرحلة الثانية من الفوترة الإلكترونية في المملكة العربية السعودية
    |
    */

    'enabled' => env('ZATCA_ENABLED', true),
    'default_environment' => env('ZATCA_DEFAULT_ENVIRONMENT', 'sandbox'),
    'default_connection_type' => env('ZATCA_DEFAULT_CONNECTION_TYPE', 'reporting'),
    
    // Base URLs for different environments
    'sandbox_base_url' => env('ZATCA_SANDBOX_BASE_URL', 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/developer-portal'),
    'production_base_url' => env('ZATCA_PRODUCTION_BASE_URL', 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/core'),

    /*
    |--------------------------------------------------------------------------
    | ZATCA API URLs
    |--------------------------------------------------------------------------
    |
    | عناوين URLs لواجهات برمجة التطبيقات الخاصة بـ ZATCA
    |
    */

    'api_urls' => [
        'sandbox' => [
            'clearance' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/developer-portal/invoices/clearance/single',
            'reporting' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/developer-portal/invoices/reporting/single',
            'compliance' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/developer-portal/compliance',
            'production_csid' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/developer-portal/production/csids',
        ],
        'production' => [
            'clearance' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/core/invoices/clearance/single',
            'reporting' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/core/invoices/reporting/single',
            'compliance' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/core/compliance',
            'production_csid' => 'https://gw-apic-gov.gazt.gov.sa/e-invoicing/core/production/csids',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Device Initialization Settings
    |--------------------------------------------------------------------------
    |
    | إعدادات تهيئة الأجهزة للمرحلة الثانية
    |
    */

    'device_initialization' => [
        'otp_expiry_minutes' => env('ZATCA_OTP_EXPIRY_MINUTES', 5),
        'max_retry_attempts' => env('ZATCA_MAX_RETRY_ATTEMPTS', 3),
        'rate_limit_per_hour' => env('ZATCA_RATE_LIMIT_PER_HOUR', 10),
        'cleanup_expired_logs_days' => env('ZATCA_CLEANUP_EXPIRED_LOGS_DAYS', 30),
    ],

    /*
    |--------------------------------------------------------------------------
    | Certificate Settings
    |--------------------------------------------------------------------------
    |
    | إعدادات الشهادات الرقمية
    |
    */

    'certificates' => [
        'default_expires_warning_days' => env('ZATCA_CERT_WARNING_DAYS', 30),
        'auto_renewal_enabled' => env('ZATCA_AUTO_RENEWAL_ENABLED', false),
        'backup_certificates' => env('ZATCA_BACKUP_CERTIFICATES', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Settings
    |--------------------------------------------------------------------------
    |
    | إعدادات الأمان والحماية
    |
    */

    'security' => [
        'encrypt_stored_keys' => env('ZATCA_ENCRYPT_STORED_KEYS', true),
        'log_sensitive_data' => env('ZATCA_LOG_SENSITIVE_DATA', false),
        'ip_whitelist_enabled' => env('ZATCA_IP_WHITELIST_ENABLED', false),
        'allowed_ips' => explode(',', env('ZATCA_ALLOWED_IPS', '')),
    ],

    /*
    |--------------------------------------------------------------------------
    | Logging Configuration
    |--------------------------------------------------------------------------
    |
    | إعدادات تسجيل العمليات والأحداث
    |
    */

    'logging' => [
        'enabled' => env('ZATCA_LOGGING_ENABLED', true),
        'log_requests' => env('ZATCA_LOG_REQUESTS', true),
        'log_responses' => env('ZATCA_LOG_RESPONSES', true),
        'log_errors' => env('ZATCA_LOG_ERRORS', true),
        'retention_days' => env('ZATCA_LOG_RETENTION_DAYS', 90),
    ],
];