<?php

return [
    /*
    |--------------------------------------------------------------------------
    | إعدادات الإشعارات التلقائية
    |--------------------------------------------------------------------------
    */
    'auto_notifications' => env('INVOICES_AUTO_NOTIFICATIONS', false),
    'payment_reminders' => env('INVOICES_PAYMENT_REMINDERS', true),
    
    /*
    |--------------------------------------------------------------------------
    | إعدادات البريد الإلكتروني
    |--------------------------------------------------------------------------
    */
    'default_creditor_email' => env('INVOICES_CREDITOR_EMAIL', ''),
    'sender_name' => env('INVOICES_SENDER_NAME', config('app.name')),
    'new_invoice_subject' => 'فاتورة جديدة رقم {invoice_number}',
    'reminder_subject' => 'تذكير بسداد فاتورة رقم {invoice_number}',
    
    /*
    |--------------------------------------------------------------------------
    | إعدادات الواتساب
    |--------------------------------------------------------------------------
    */
    'whatsapp_enabled' => env('INVOICES_WHATSAPP_ENABLED', true),
    'whatsapp_auto' => env('INVOICES_WHATSAPP_AUTO', false),
    'whatsapp_template' => 'مرحباً {customer_name}، نرسل لكم فاتورة رقم {invoice_number} بمبلغ {total_amount} ر.س. يرجى المراجعة والسداد في الموعد المحدد. شكراً لتعاملكم معنا.',
    
    /*
    |--------------------------------------------------------------------------
    | إعدادات التذكيرات
    |--------------------------------------------------------------------------
    */
    'first_reminder_days' => env('INVOICES_FIRST_REMINDER_DAYS', 3),
    'second_reminder_days' => env('INVOICES_SECOND_REMINDER_DAYS', 7),
    'final_reminder_days' => env('INVOICES_FINAL_REMINDER_DAYS', 15),
    
    /*
    |--------------------------------------------------------------------------
    | طرق الإرسال المفضلة
    |--------------------------------------------------------------------------
    */
    'reminder_email' => env('INVOICES_REMINDER_EMAIL', true),
    'reminder_whatsapp' => env('INVOICES_REMINDER_WHATSAPP', false),
    
    /*
    |--------------------------------------------------------------------------
    | أنواع الإشعارات
    |--------------------------------------------------------------------------
    */
    'notify_new_invoice' => env('INVOICES_NOTIFY_NEW_INVOICE', true),
    'notify_payment_received' => env('INVOICES_NOTIFY_PAYMENT_RECEIVED', true),
    'notify_overdue' => env('INVOICES_NOTIFY_OVERDUE', true),
    'notify_zatca_status' => env('INVOICES_NOTIFY_ZATCA_STATUS', true),
    
    /*
    |--------------------------------------------------------------------------
    | إعدادات إدارة الديون
    |--------------------------------------------------------------------------
    */
    'debt_management' => [
        'auto_mark_high_risk_days' => env('INVOICES_HIGH_RISK_DAYS', 90),
        'auto_mark_high_risk_amount' => env('INVOICES_HIGH_RISK_AMOUNT', 10000),
        'collection_agency_threshold' => env('INVOICES_COLLECTION_THRESHOLD', 120),
        'write_off_threshold' => env('INVOICES_WRITE_OFF_THRESHOLD', 365),
    ],
    
    /*
    |--------------------------------------------------------------------------
    | إعدادات التقارير
    |--------------------------------------------------------------------------
    */
    'reports' => [
        'default_period_months' => 12,
        'export_formats' => ['csv', 'pdf', 'excel'],
        'auto_generate_monthly_reports' => false,
        'send_monthly_reports_to' => [],
    ],
    
    /*
    |--------------------------------------------------------------------------
    | إعدادات الأمان
    |--------------------------------------------------------------------------
    */
    'security' => [
        'require_approval_above_amount' => 0, // 0 = معطل
        'log_all_actions' => true,
        'encrypt_sensitive_data' => false,
        'backup_invoices_daily' => true,
    ],
    
    /*
    |--------------------------------------------------------------------------
    | إعدادات الأداء
    |--------------------------------------------------------------------------
    */
    'performance' => [
        'cache_reports_minutes' => 60,
        'paginate_invoices' => 20,
        'paginate_customers' => 15,
        'compress_old_invoices' => true,
    ],
];