<?php

return [
    /*
    |--------------------------------------------------------------------------
    | إعدادات النظام المحاسبي
    |--------------------------------------------------------------------------
    |
    | هذه الإعدادات تتحكم في سلوك النظام المحاسبي
    |
    */

    // إعدادات عامة
    'general' => [
        'company_name' => env('ACCOUNTING_COMPANY_NAME', 'شركة برايما للتقنية'),
        'company_address' => env('ACCOUNTING_COMPANY_ADDRESS', 'الرياض، المملكة العربية السعودية'),
        'company_tax_number' => env('ACCOUNTING_TAX_NUMBER', '123456789000003'),
        'company_cr_number' => env('ACCOUNTING_CR_NUMBER', '1010123456'),
        'fiscal_year_start' => env('ACCOUNTING_FISCAL_YEAR_START', '01-01'), // MM-DD
        'currency' => env('ACCOUNTING_CURRENCY', 'SAR'),
        'currency_symbol' => env('ACCOUNTING_CURRENCY_SYMBOL', 'ريال'),
        'decimal_places' => env('ACCOUNTING_DECIMAL_PLACES', 2),
        'thousand_separator' => env('ACCOUNTING_THOUSAND_SEPARATOR', ','),
        'decimal_separator' => env('ACCOUNTING_DECIMAL_SEPARATOR', '.'),
    ],

    // إعدادات دليل الحسابات
    'chart_of_accounts' => [
        'auto_generate_codes' => env('ACCOUNTING_AUTO_GENERATE_CODES', true),
        'code_length' => env('ACCOUNTING_CODE_LENGTH', 4),
        'allow_duplicate_names' => env('ACCOUNTING_ALLOW_DUPLICATE_NAMES', false),
        'require_parent_for_details' => env('ACCOUNTING_REQUIRE_PARENT_FOR_DETAILS', true),
        'auto_calculate_balances' => env('ACCOUNTING_AUTO_CALCULATE_BALANCES', true),
        
        // أنواع الحسابات ورموزها
        'account_types' => [
            'asset' => [
                'code_prefix' => '1',
                'name_ar' => 'الأصول',
                'name_en' => 'Assets',
                'normal_balance' => 'debit',
                'subtypes' => [
                    'current' => ['code' => '11', 'name' => 'الأصول المتداولة'],
                    'fixed' => ['code' => '12', 'name' => 'الأصول الثابتة'],
                    'intangible' => ['code' => '13', 'name' => 'الأصول غير الملموسة'],
                    'investment' => ['code' => '14', 'name' => 'الاستثمارات'],
                ]
            ],
            'liability' => [
                'code_prefix' => '2',
                'name_ar' => 'الخصوم',
                'name_en' => 'Liabilities',
                'normal_balance' => 'credit',
                'subtypes' => [
                    'current' => ['code' => '21', 'name' => 'الخصوم المتداولة'],
                    'long_term' => ['code' => '22', 'name' => 'الخصوم طويلة الأجل'],
                ]
            ],
            'equity' => [
                'code_prefix' => '3',
                'name_ar' => 'حقوق الملكية',
                'name_en' => 'Equity',
                'normal_balance' => 'credit',
                'subtypes' => [
                    'capital' => ['code' => '31', 'name' => 'رأس المال'],
                    'retained_earnings' => ['code' => '32', 'name' => 'الأرباح المحتجزة'],
                    'drawing' => ['code' => '33', 'name' => 'مسحوبات الشركاء'],
                ]
            ],
            'revenue' => [
                'code_prefix' => '4',
                'name_ar' => 'الإيرادات',
                'name_en' => 'Revenue',
                'normal_balance' => 'credit',
                'subtypes' => [
                    'sales' => ['code' => '41', 'name' => 'إيرادات المبيعات'],
                    'services' => ['code' => '42', 'name' => 'إيرادات الخدمات'],
                    'other' => ['code' => '43', 'name' => 'إيرادات أخرى'],
                ]
            ],
            'expense' => [
                'code_prefix' => '5',
                'name_ar' => 'المصروفات',
                'name_en' => 'Expenses',
                'normal_balance' => 'debit',
                'subtypes' => [
                    'cogs' => ['code' => '51', 'name' => 'تكلفة البضاعة المباعة'],
                    'operating' => ['code' => '52', 'name' => 'المصروفات التشغيلية'],
                    'administrative' => ['code' => '53', 'name' => 'المصروفات الإدارية'],
                    'selling' => ['code' => '54', 'name' => 'مصروفات البيع والتسويق'],
                    'financial' => ['code' => '55', 'name' => 'المصروفات المالية'],
                ]
            ],
        ],
    ],

    // إعدادات القيود المحاسبية
    'journal_entries' => [
        'require_approval' => env('ACCOUNTING_REQUIRE_APPROVAL', true),
        'auto_generate_reference' => env('ACCOUNTING_AUTO_GENERATE_REFERENCE', true),
        'reference_prefix' => env('ACCOUNTING_REFERENCE_PREFIX', 'JE'),
        'reference_format' => env('ACCOUNTING_REFERENCE_FORMAT', '{prefix}{year}{number}'),
        'allow_edit_approved' => env('ACCOUNTING_ALLOW_EDIT_APPROVED', false),
        'allow_delete_approved' => env('ACCOUNTING_ALLOW_DELETE_APPROVED', false),
        'require_cost_center' => env('ACCOUNTING_REQUIRE_COST_CENTER', false),
        'balance_tolerance' => env('ACCOUNTING_BALANCE_TOLERANCE', 0.01),
        'auto_post_cash_transactions' => env('ACCOUNTING_AUTO_POST_CASH_TRANSACTIONS', true),
    ],

    // إعدادات المعاملات النقدية
    'cash_transactions' => [
        'auto_generate_reference' => env('CASH_AUTO_GENERATE_REFERENCE', true),
        'receipt_prefix' => env('CASH_RECEIPT_PREFIX', 'CR'),
        'payment_prefix' => env('CASH_PAYMENT_PREFIX', 'CP'),
        'require_approval' => env('CASH_REQUIRE_APPROVAL', false),
        'auto_create_journal_entry' => env('CASH_AUTO_CREATE_JOURNAL_ENTRY', true),
        'default_cash_account' => env('CASH_DEFAULT_ACCOUNT', null),
        'require_reconciliation' => env('CASH_REQUIRE_RECONCILIATION', true),
    ],

    // إعدادات مراكز التكلفة
    'cost_centers' => [
        'enabled' => env('COST_CENTERS_ENABLED', true),
        'require_for_expenses' => env('COST_CENTERS_REQUIRE_FOR_EXPENSES', false),
        'allow_budget_exceeded' => env('COST_CENTERS_ALLOW_BUDGET_EXCEEDED', true),
        'budget_warning_threshold' => env('COST_CENTERS_BUDGET_WARNING_THRESHOLD', 80), // %
        'auto_calculate_actual' => env('COST_CENTERS_AUTO_CALCULATE_ACTUAL', true),
        'default_budget_period' => env('COST_CENTERS_DEFAULT_BUDGET_PERIOD', 'annual'),
    ],

    // إعدادات التقارير
    'reports' => [
        'default_date_range' => env('REPORTS_DEFAULT_DATE_RANGE', 'current_month'),
        'auto_refresh' => env('REPORTS_AUTO_REFRESH', false),
        'export_formats' => ['excel', 'pdf', 'csv'],
        'max_export_records' => env('REPORTS_MAX_EXPORT_RECORDS', 10000),
        'cache_duration' => env('REPORTS_CACHE_DURATION', 3600), // seconds
        
        // إعدادات طباعة التقارير
        'print_settings' => [
            'show_company_header' => true,
            'show_date_range' => true,
            'show_page_numbers' => true,
            'show_generation_time' => true,
            'font_size' => '12px',
            'font_family' => 'Arial, sans-serif',
        ],
    ],

    // إعدادات الأمان والصلاحيات
    'security' => [
        'require_authentication' => env('ACCOUNTING_REQUIRE_AUTH', true),
        'check_permissions' => env('ACCOUNTING_CHECK_PERMISSIONS', true),
        'log_all_operations' => env('ACCOUNTING_LOG_OPERATIONS', true),
        'audit_trail' => env('ACCOUNTING_AUDIT_TRAIL', true),
        'backup_before_delete' => env('ACCOUNTING_BACKUP_BEFORE_DELETE', true),
        
        // مستويات الصلاحيات
        'permission_levels' => [
            'viewer' => [
                'name' => 'مشاهد',
                'permissions' => ['view_accounts', 'view_journal_entries', 'view_reports']
            ],
            'accountant' => [
                'name' => 'محاسب',
                'permissions' => ['view_*', 'create_*', 'edit_*', 'export_*']
            ],
            'financial_manager' => [
                'name' => 'مدير مالي',
                'permissions' => ['*']
            ],
            'admin' => [
                'name' => 'مدير النظام',
                'permissions' => ['*']
            ],
        ],
    ],

    // إعدادات التكامل
    'integration' => [
        'api_enabled' => env('ACCOUNTING_API_ENABLED', false),
        'webhook_enabled' => env('ACCOUNTING_WEBHOOK_ENABLED', false),
        'sync_with_inventory' => env('ACCOUNTING_SYNC_INVENTORY', true),
        'sync_with_invoicing' => env('ACCOUNTING_SYNC_INVOICING', true),
        'external_systems' => [
            'zatca' => [
                'enabled' => env('ZATCA_INTEGRATION_ENABLED', false),
                'auto_sync' => env('ZATCA_AUTO_SYNC', false),
            ],
            'banks' => [
                'enabled' => env('BANK_INTEGRATION_ENABLED', false),
                'auto_import_statements' => env('BANK_AUTO_IMPORT', false),
            ],
        ],
    ],

    // إعدادات الصيانة والأداء
    'maintenance' => [
        'auto_backup' => env('ACCOUNTING_AUTO_BACKUP', true),
        'backup_frequency' => env('ACCOUNTING_BACKUP_FREQUENCY', 'daily'),
        'cleanup_old_data' => env('ACCOUNTING_CLEANUP_OLD_DATA', true),
        'cleanup_after_days' => env('ACCOUNTING_CLEANUP_AFTER_DAYS', 365),
        'auto_calculate_balances' => env('ACCOUNTING_AUTO_CALCULATE_BALANCES', true),
        'balance_calculation_frequency' => env('ACCOUNTING_BALANCE_FREQUENCY', 'daily'),
        
        // إعدادات الأداء
        'cache_enabled' => env('ACCOUNTING_CACHE_ENABLED', true),
        'cache_reports' => env('ACCOUNTING_CACHE_REPORTS', true),
        'lazy_load_accounts' => env('ACCOUNTING_LAZY_LOAD', true),
        'pagination_size' => env('ACCOUNTING_PAGINATION_SIZE', 50),
    ],

    // إعدادات التنبيهات والإشعارات
    'notifications' => [
        'enabled' => env('ACCOUNTING_NOTIFICATIONS_ENABLED', true),
        'email_enabled' => env('ACCOUNTING_EMAIL_NOTIFICATIONS', true),
        'sms_enabled' => env('ACCOUNTING_SMS_NOTIFICATIONS', false),
        
        // أنواع التنبيهات
        'alert_types' => [
            'unbalanced_entries' => [
                'enabled' => true,
                'level' => 'error',
                'recipients' => ['financial_manager', 'admin']
            ],
            'budget_exceeded' => [
                'enabled' => true,
                'level' => 'warning',
                'threshold' => 90, // %
                'recipients' => ['cost_center_manager', 'financial_manager']
            ],
            'large_transactions' => [
                'enabled' => true,
                'level' => 'info',
                'threshold' => 100000, // amount
                'recipients' => ['financial_manager', 'admin']
            ],
            'negative_cash_balance' => [
                'enabled' => true,
                'level' => 'critical',
                'recipients' => ['financial_manager', 'admin']
            ],
        ],
    ],

    // إعدادات التطوير والاختبار
    'development' => [
        'debug_mode' => env('ACCOUNTING_DEBUG', false),
        'test_data_enabled' => env('ACCOUNTING_TEST_DATA', false),
        'mock_external_apis' => env('ACCOUNTING_MOCK_APIS', false),
        'log_sql_queries' => env('ACCOUNTING_LOG_SQL', false),
        'profiling_enabled' => env('ACCOUNTING_PROFILING', false),
    ],

    // الثوابت المحاسبية
    'constants' => [
        'max_decimal_places' => 4,
        'max_account_code_length' => 20,
        'max_account_name_length' => 255,
        'max_description_length' => 1000,
        'min_password_length' => 8,
        'session_timeout' => 3600, // seconds
        'max_file_upload_size' => '10MB',
        'supported_file_types' => ['xlsx', 'xls', 'csv'],
    ],
];