<?php
/**
 * ملف فحص Migration - تشغيل مؤقت للتحقق من الحقول
 */

require_once __DIR__ . '/vendor/autoload.php';

// تحميل متغيرات البيئة
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

try {
    // الاتصال بقاعدة البيانات
    $pdo = new PDO(
        "mysql:host=" . $_ENV['DB_HOST'] . ";dbname=" . $_ENV['DB_DATABASE'],
        $_ENV['DB_USERNAME'],
        $_ENV['DB_PASSWORD']
    );
    
    echo "🔍 === فحص شامل لقاعدة البيانات ===\n\n";
    
    // فحص إذا كانت الحقول موجودة
    $stmt = $pdo->query("DESCRIBE invoices");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    $requiredFields = [
        'payment_method',
        'paid_amount',
        'remaining_amount',
        'payment_status',
        'payment_date',
        'payment_notes',
        'creditor_notification_sent',
        'creditor_notification_sent_at',
        'debtor_notification_sent',
        'debtor_notification_sent_at',
        'is_high_risk',
        'risk_marked_at',
        'last_reminder_sent_at'
    ];
    
    echo "📋 فحص الحقول المطلوبة:\n";
    $missingFields = [];
    
    foreach ($requiredFields as $field) {
        if (in_array($field, $columns)) {
            echo "✅ $field\n";
        } else {
            echo "❌ $field مفقود\n";
            $missingFields[] = $field;
        }
    }
    
    // فحص Migration المطلوب تشغيله
    echo "\n📊 حالة Migration:\n";
    $stmt = $pdo->query("SELECT * FROM migrations WHERE migration LIKE '%add_payment_fields_to_invoices_table%'");
    $migration = $stmt->fetch();
    
    if ($migration) {
        echo "✅ تم تشغيل Migration في: " . $migration['created_at'] . "\n";
    } else {
        echo "❌ لم يتم تشغيل Migration بعد!\n";
        echo "   👉 يرجى تشغيل: php artisan migrate\n";
    }
    
    // عرض جميع الحقول الموجودة
    echo "\n📄 جميع الحقول الموجودة في جدول invoices:\n";
    foreach ($columns as $column) {
        echo "   - $column\n";
    }
    
    // ملخص النتائج
    echo "\n📈 ملخص النتائج:\n";
    echo "   - إجمالي الحقول الموجودة: " . count($columns) . "\n";
    echo "   - الحقول المطلوبة: " . count($requiredFields) . "\n";
    echo "   - الحقول المفقودة: " . count($missingFields) . "\n";
    
    if (count($missingFields) > 0) {
        echo "\n🚨 الإجراء المطلوب:\n";
        echo "   تشغيل: php artisan migrate\n";
        echo "\n   الحقول المفقودة:\n";
        foreach ($missingFields as $field) {
            echo "   - $field\n";
        }
    } else {
        echo "\n🎉 جميع الحقول موجودة! النظام جاهز للعمل.\n";
    }
    
    // فحص عدد الفواتير الموجودة
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM invoices");
    $invoiceCount = $stmt->fetch()['count'];
    echo "\n📊 عدد الفواتير الموجودة: $invoiceCount\n";
    
} catch (Exception $e) {
    echo "❌ خطأ في الاتصال: " . $e->getMessage() . "\n\n";
    echo "🔧 للإصلاح:\n";
    echo "1. تأكد من إعدادات قاعدة البيانات في ملف .env\n";
    echo "2. تأكد من تشغيل خادم قاعدة البيانات (MySQL/MariaDB)\n";
    echo "3. تأكد من وجود قاعدة البيانات\n";
    echo "4. تأكد من صحة اسم المستخدم وكلمة المرور\n";
}
?>