<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ZatcaSyncCompletedNotification extends Notification
{
    use Queueable;

    protected $results;

    /**
     * Create a new notification instance.
     */
    public function __construct($results)
    {
        $this->results = $results;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $subject = 'تم الانتهاء من مزامنة فواتير ZATCA';
        
        $message = (new MailMessage)
            ->subject($subject)
            ->greeting('السلام عليكم ' . $notifiable->name)
            ->line('تم الانتهاء من عملية مزامنة الفواتير مع نظام ZATCA.')
            ->line('النتائج:')
            ->line('• إجمالي الفواتير: ' . $this->results['total'])
            ->line('• نجح: ' . $this->results['success'])
            ->line('• فشل: ' . $this->results['failed']);

        if ($this->results['failed'] > 0) {
            $message->line('يرجى مراجعة سجل العمليات لمزيد من التفاصيل حول الفواتير التي فشلت.');
        }

        $message->action('عرض نافذة المزامنة', url('/invoices/sync'))
            ->line('شكراً لاستخدامكم نظامنا.');

        return $message;
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'zatca_sync_completed',
            'title' => 'مزامنة ZATCA مكتملة',
            'message' => "تم مزامنة {$this->results['total']} فاتورة - نجح: {$this->results['success']}, فشل: {$this->results['failed']}",
            'results' => $this->results,
            'icon' => 'fas fa-sync-alt',
            'color' => $this->results['failed'] > 0 ? 'warning' : 'success'
        ];
    }
}