<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'role',
        'is_active',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'is_active' => 'boolean',
        ];
    }

    /**
     * الحصول على اسم الدور باللغة العربية
     */
    public function getRoleNameAttribute()
    {
        $roles = [
            'admin' => 'مدير النظام',
            'manager' => 'مدير',
            'employee' => 'موظف',
        ];

        return $roles[$this->role] ?? 'غير محدد';
    }

    /**
     * الحصول على حالة المستخدم باللغة العربية
     */
    public function getStatusNameAttribute()
    {
        return $this->is_active ? 'نشط' : 'غير نشط';
    }

    /**
     * التحقق من كون المستخدم مدير نظام
     */
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    /**
     * التحقق من كون المستخدم مدير
     */
    public function isManager()
    {
        return $this->role === 'manager';
    }

    /**
     * التحقق من كون المستخدم موظف
     */
    public function isEmployee()
    {
        return $this->role === 'employee';
    }
}
