<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PurchaseOrderItem extends Model
{
    protected $fillable = [
        'purchase_order_id',
        'product_id',
        'quantity',
        'unit_price',
        'tax_rate',
        'total_amount',
        'notes',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'unit_price' => 'decimal:2',
        'tax_rate' => 'decimal:2',
        'total_amount' => 'decimal:2',
    ];

    /**
     * علاقة مع أمر الشراء
     */
    public function purchaseOrder(): BelongsTo
    {
        return $this->belongsTo(PurchaseOrder::class);
    }

    /**
     * علاقة مع المنتج
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * حساب مبلغ الضريبة
     */
    public function getTaxAmountAttribute(): float
    {
        return ($this->unit_price * $this->quantity) * ($this->tax_rate / 100);
    }

    /**
     * حساب المبلغ بدون ضريبة
     */
    public function getSubtotalAttribute(): float
    {
        return $this->unit_price * $this->quantity;
    }
}