<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InventoryAdjustmentItem extends Model
{
    protected $fillable = [
        'inventory_adjustment_id',
        'product_id',
        'current_quantity',
        'adjusted_quantity',
        'quantity_difference',
        'unit_cost',
        'reason',
        'notes',
    ];

    protected $casts = [
        'current_quantity' => 'integer',
        'adjusted_quantity' => 'integer',
        'quantity_difference' => 'integer',
        'unit_cost' => 'decimal:2',
    ];

    /**
     * علاقة مع تسوية المخزون
     */
    public function inventoryAdjustment(): BelongsTo
    {
        return $this->belongsTo(InventoryAdjustment::class);
    }

    /**
     * علاقة مع المنتج
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * حساب القيمة الإجمالية للتغيير
     */
    public function getTotalValueChangeAttribute(): float
    {
        return $this->quantity_difference * $this->unit_cost;
    }

    /**
     * التحقق من كون التغيير زيادة أم نقص
     */
    public function isIncrease(): bool
    {
        return $this->quantity_difference > 0;
    }

    public function isDecrease(): bool
    {
        return $this->quantity_difference < 0;
    }
}