<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class GoodsReceiptItem extends Model
{
    protected $fillable = [
        'goods_receipt_id',
        'purchase_order_item_id',
        'product_id',
        'ordered_quantity',
        'received_quantity',
        'unit_cost',
        'total_cost',
        'notes',
    ];

    protected $casts = [
        'ordered_quantity' => 'integer',
        'received_quantity' => 'integer',
        'unit_cost' => 'decimal:2',
        'total_cost' => 'decimal:2',
    ];

    /**
     * علاقة مع استلام البضائع
     */
    public function goodsReceipt(): BelongsTo
    {
        return $this->belongsTo(GoodsReceipt::class);
    }

    /**
     * علاقة مع عنصر أمر الشراء
     */
    public function purchaseOrderItem(): BelongsTo
    {
        return $this->belongsTo(PurchaseOrderItem::class);
    }

    /**
     * علاقة مع المنتج
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * حساب الكمية المتبقية للاستلام
     */
    public function getRemainingQuantityAttribute(): int
    {
        return $this->ordered_quantity - $this->received_quantity;
    }

    /**
     * التحقق من اكتمال الاستلام
     */
    public function isFullyReceived(): bool
    {
        return $this->received_quantity >= $this->ordered_quantity;
    }
}