<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DeviceInitializationLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'csid_number',
        'otp_token',
        'otp_requested_at',
        'otp_expires_at',
        'otp_verified_at',
        'verification_status',
        'ip_address',
        'user_agent',
        'request_data',
        'response_data',
        'error_message',
    ];

    protected $casts = [
        'otp_requested_at' => 'datetime',
        'otp_expires_at' => 'datetime',
        'otp_verified_at' => 'datetime',
        'request_data' => 'array',
        'response_data' => 'array',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * التحقق من انتهاء صلاحية OTP
     */
    public function isOtpExpired(): bool
    {
        return $this->otp_expires_at && now()->isAfter($this->otp_expires_at);
    }

    /**
     * تحديث حالة التحقق
     */
    public function updateVerificationStatus(string $status, ?string $errorMessage = null): void
    {
        $this->update([
            'verification_status' => $status,
            'error_message' => $errorMessage,
        ]);
    }
}