<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckInventoryPermissions
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $permission = null): Response
    {
        // التحقق من تسجيل الدخول
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $user = auth()->user();

        // السماح للمدير بكل شيء
        if ($user->isAdmin()) {
            return $next($request);
        }

        // التحقق من الصلاحيات المحددة
        if ($permission) {
            switch ($permission) {
                case 'suppliers.manage':
                    // يمكن للمدير وموظف المشتريات إدارة الموردين
                    if (!in_array($user->role, ['admin', 'manager', 'purchasing'])) {
                        abort(403, 'ليس لديك صلاحية للوصول لهذه الصفحة');
                    }
                    break;

                case 'purchase-orders.manage':
                    // يمكن للمدير وموظف المشتريات إدارة أوامر الشراء
                    if (!in_array($user->role, ['admin', 'manager', 'purchasing'])) {
                        abort(403, 'ليس لديك صلاحية لإدارة أوامر الشراء');
                    }
                    break;

                case 'inventory.manage':
                    // يمكن للمدير وموظف المخزون إدارة المخزون
                    if (!in_array($user->role, ['admin', 'manager', 'inventory'])) {
                        abort(403, 'ليس لديك صلاحية لإدارة المخزون');
                    }
                    break;

                case 'goods-receipts.manage':
                    // يمكن للمدير وموظف المخزون والمشتريات إدارة استلام البضائع
                    if (!in_array($user->role, ['admin', 'manager', 'inventory', 'purchasing'])) {
                        abort(403, 'ليس لديك صلاحية لإدارة استلام البضائع');
                    }
                    break;

                case 'adjustments.approve':
                    // فقط المدير يمكنه اعتماد التسويات
                    if (!in_array($user->role, ['admin', 'manager'])) {
                        abort(403, 'ليس لديك صلاحية لاعتماد تسويات المخزون');
                    }
                    break;

                case 'inventory.view':
                    // الجميع يمكنهم عرض المخزون
                    break;

                default:
                    // صلاحية افتراضية - المدير فقط
                    if (!$user->isAdmin()) {
                        abort(403, 'ليس لديك صلاحية للوصول لهذه الصفحة');
                    }
                    break;
            }
        }

        return $next($request);
    }
}