<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Fill;

class CashFlowExport implements FromArray, WithHeadings, WithStyles, WithTitle, WithColumnWidths
{
    protected $data;
    protected $startDate;
    protected $endDate;

    public function __construct($data, $startDate, $endDate)
    {
        $this->data = $data;
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function array(): array
    {
        $rows = [];
        
        // معلومات التقرير
        $rows[] = ['تقرير التدفق النقدي'];
        $rows[] = ['الفترة: من ' . $this->startDate . ' إلى ' . $this->endDate];
        $rows[] = ['تاريخ الإنشاء: ' . now()->format('Y-m-d H:i:s')];
        $rows[] = [''];

        // الأنشطة التشغيلية
        $rows[] = ['الأنشطة التشغيلية', '', ''];
        foreach ($this->data['operating_activities'] as $activity) {
            $rows[] = [
                $activity['description'],
                number_format($activity['amount'], 2),
                ''
            ];
        }
        $rows[] = [
            'صافي التدفق النقدي من الأنشطة التشغيلية',
            number_format($this->data['operating_cash_flow'], 2),
            ''
        ];
        $rows[] = [''];

        // الأنشطة الاستثمارية
        $rows[] = ['الأنشطة الاستثمارية', '', ''];
        foreach ($this->data['investing_activities'] as $activity) {
            $rows[] = [
                $activity['description'],
                number_format($activity['amount'], 2),
                ''
            ];
        }
        $rows[] = [
            'صافي التدفق النقدي من الأنشطة الاستثمارية',
            number_format($this->data['investing_cash_flow'], 2),
            ''
        ];
        $rows[] = [''];

        // الأنشطة التمويلية
        $rows[] = ['الأنشطة التمويلية', '', ''];
        foreach ($this->data['financing_activities'] as $activity) {
            $rows[] = [
                $activity['description'],
                number_format($activity['amount'], 2),
                ''
            ];
        }
        $rows[] = [
            'صافي التدفق النقدي من الأنشطة التمويلية',
            number_format($this->data['financing_cash_flow'], 2),
            ''
        ];
        $rows[] = [''];

        // الملخص
        $rows[] = ['ملخص التدفق النقدي', '', ''];
        $rows[] = [
            'الرصيد النقدي في بداية الفترة',
            number_format($this->data['beginning_cash_balance'], 2),
            ''
        ];
        $rows[] = [
            'صافي التدفق النقدي من الأنشطة التشغيلية',
            number_format($this->data['operating_cash_flow'], 2),
            ''
        ];
        $rows[] = [
            'صافي التدفق النقدي من الأنشطة الاستثمارية',
            number_format($this->data['investing_cash_flow'], 2),
            ''
        ];
        $rows[] = [
            'صافي التدفق النقدي من الأنشطة التمويلية',
            number_format($this->data['financing_cash_flow'], 2),
            ''
        ];
        $rows[] = [
            'صافي التغير في النقدية',
            number_format($this->data['net_cash_flow'], 2),
            ''
        ];
        $rows[] = [
            'الرصيد النقدي في نهاية الفترة',
            number_format($this->data['ending_cash_balance'], 2),
            ''
        ];

        return $rows;
    }

    public function headings(): array
    {
        return [
            'البيان',
            'المبلغ (ريال)',
            'ملاحظات'
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // تنسيق العنوان الرئيسي
            1 => [
                'font' => ['bold' => true, 'size' => 16],
                'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
            ],
            
            // تنسيق عناوين الأقسام
            'A5:C5' => [
                'font' => ['bold' => true, 'size' => 12],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'E3F2FD']
                ]
            ],
            
            // محاذاة الأرقام إلى اليمين
            'B:B' => [
                'alignment' => ['horizontal' => Alignment::HORIZONTAL_RIGHT]
            ],
            
            // تنسيق الإجماليات
            'A' => [
                'font' => ['bold' => true]
            ]
        ];
    }

    public function title(): string
    {
        return 'التدفق النقدي';
    }

    public function columnWidths(): array
    {
        return [
            'A' => 40,
            'B' => 20,
            'C' => 20
        ];
    }
}