<?php

namespace App\Exports;

use App\Models\Account;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class AccountsExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    public function collection()
    {
        return Account::with('parent')->orderBy('code')->get();
    }

    public function headings(): array
    {
        return [
            'رمز الحساب',
            'اسم الحساب',
            'الاسم بالإنجليزية',
            'نوع الحساب',
            'النوع الفرعي',
            'الحساب الأب',
            'المستوى',
            'طبيعة الحساب',
            'الرصيد الافتتاحي',
            'الرصيد الحالي',
            'نشط',
            'حساب نقدي',
            'حساب بنكي',
            'حساب تحكم',
            'الوصف'
        ];
    }

    public function map($account): array
    {
        return [
            $account->code,
            $account->name,
            $account->name_en,
            $this->getTypeText($account->type),
            $this->getSubtypeText($account->subtype),
            $account->parent ? $account->parent->name : '',
            $account->level,
            $account->debit_credit === 'debit' ? 'مدين' : 'دائن',
            number_format($account->opening_balance, 2),
            number_format($account->current_balance, 2),
            $account->is_active ? 'نعم' : 'لا',
            $account->is_cash_account ? 'نعم' : 'لا',
            $account->is_bank_account ? 'نعم' : 'لا',
            $account->is_control_account ? 'نعم' : 'لا',
            $account->description
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }

    private function getTypeText($type)
    {
        $types = [
            'asset' => 'أصول',
            'liability' => 'خصوم',
            'equity' => 'حقوق الملكية',
            'revenue' => 'إيرادات',
            'expense' => 'مصروفات'
        ];

        return $types[$type] ?? $type;
    }

    private function getSubtypeText($subtype)
    {
        $subtypes = [
            'current_asset' => 'أصول متداولة',
            'fixed_asset' => 'أصول ثابتة',
            'current_liability' => 'خصوم متداولة',
            'long_term_liability' => 'خصوم طويلة الأجل',
            'capital' => 'رأس المال',
            'retained_earnings' => 'أرباح محتجزة',
            'operating_revenue' => 'إيرادات تشغيلية',
            'other_revenue' => 'إيرادات أخرى',
            'operating_expense' => 'مصروفات تشغيلية',
            'other_expense' => 'مصروفات أخرى',
            'cost_of_goods_sold' => 'تكلفة البضاعة المباعة'
        ];

        return $subtypes[$subtype] ?? $subtype;
    }
}