<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\DeviceInitializationLog;
use Carbon\Carbon;

class CleanupZatcaLogs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'zatca:cleanup-logs {--days=30 : Number of days to keep logs}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'تنظيف سجلات تهيئة الأجهزة القديمة من قاعدة البيانات';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $days = $this->option('days');
        $cutoffDate = Carbon::now()->subDays($days);

        $this->info("بدء تنظيف سجلات تهيئة الأجهزة الأقدم من {$days} يوم...");

        // حذف السجلات المكتملة والقديمة
        $deletedVerified = DeviceInitializationLog::where('verification_status', 'verified')
            ->where('created_at', '<', $cutoffDate)
            ->count();

        DeviceInitializationLog::where('verification_status', 'verified')
            ->where('created_at', '<', $cutoffDate)
            ->delete();

        // حذف السجلات المنتهية الصلاحية والقديمة
        $deletedExpired = DeviceInitializationLog::where('verification_status', 'expired')
            ->where('created_at', '<', $cutoffDate)
            ->count();

        DeviceInitializationLog::where('verification_status', 'expired')
            ->where('created_at', '<', $cutoffDate)
            ->delete();

        // حذف السجلات الفاشلة والقديمة
        $deletedFailed = DeviceInitializationLog::where('verification_status', 'failed')
            ->where('created_at', '<', $cutoffDate)
            ->count();

        DeviceInitializationLog::where('verification_status', 'failed')
            ->where('created_at', '<', $cutoffDate)
            ->delete();

        $totalDeleted = $deletedVerified + $deletedExpired + $deletedFailed;

        $this->info("تم حذف {$totalDeleted} سجل:");
        $this->line("  - سجلات مكتملة: {$deletedVerified}");
        $this->line("  - سجلات منتهية الصلاحية: {$deletedExpired}");
        $this->line("  - سجلات فاشلة: {$deletedFailed}");

        // تحديث السجلات المعلقة المنتهية الصلاحية
        $expiredPending = DeviceInitializationLog::where('verification_status', 'pending')
            ->where('otp_expires_at', '<', now())
            ->update(['verification_status' => 'expired']);

        if ($expiredPending > 0) {
            $this->info("تم تحديث {$expiredPending} سجل معلق منتهي الصلاحية");
        }

        $this->info('تم إكمال عملية التنظيف بنجاح!');

        return Command::SUCCESS;
    }
}